<?php

namespace App\Http\Controllers\Api;

use App\Models\User;
use App\Models\Branch;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class UserController extends Controller
{

    public function index (Request $request)
    {
        if ($request->uuid) {
            $branch = Branch::where('uuid', $request->uuid)->firstOrFail();
            return User::whereRole('Artist')->where('branch_id', $branch->id)->select('id','name')->get();
        }

        if ($request->artists) {
            return User::whereRole('Artist')->get();
        }

        return User::where('role', '!=', 'Artist')->get();

    }

    public function store (Request $request)
    {
        $request->validate([
            'name' => 'required',
            'branch_id' => 'required|exists:branches,id',
            'username' => 'required|unique:users,username',
            'password' => 'required|min:6'
        ]);

        User::create($request->all());
        return 1;
    }

    public function update (Request $request, $id)
    {
        $request->validate([
            'name' => 'required',
            'branch_id' => 'required|exists:branches,id',
            'username' => 'required|unique:users,username,' . $id,
            'password' => 'nullable'
        ]);

        $user = User::find($id);

        if (!$request->password) {
            $request->request->remove('password');
        }

        $user->update($request->all());
        return 1;
    }


}
