<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\JobOrder;
use App\Models\Payment;
use Illuminate\Http\Request;

class PaymentController extends Controller
{

    public function store (Request $request)
    {
        $request->validate([
            'job_order_id' => 'required|exists:job_orders,id',
            'amount' => 'required',
            'payment_type' => 'required'
        ]);

        $jo = JobOrder::find($request->job_order_id);

        $payment = Payment::create($request->all());

        if ($request->payment_type === 'Full Payment') {
            $jo->status = 'Completed';
            $jo->save();
        }

        return $payment;
    }
}
