<?php

namespace App\Http\Controllers\Api;

use App\Models\Branch;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class BranchController extends Controller
{

    public function index (Request $request)
    {
        return Branch::all();

    }

    public function store (Request $request)
    {
        $request->validate([
            'name' => 'required|unique:branches,name',
            'pos_config_id' => 'required'
        ]);

        $request->request->add([
            'uuid' => Str::uuid()
        ]);

        Branch::create($request->all());
        return 1;
    }

    public function update (Request $request, $id)
    {
        $request->validate([
            'name' => 'required|unique:branches,name,' . $id,
            'pos_config_id' => 'required'
        ]);

        $branch = Branch::find($id);
        $branch->update($request->all());
        return 1;
    }
}
