<?php

namespace App\Http\Controllers\Api;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\ValidationException;

class AuthController extends Controller
{
    public function login (Request $request)
    {
        $request->validate([
            'username' => 'required|exists:users,username',
            'password' => 'required',
        ]);

        $user = User::where('username', $request->username)->where('is_active', 1)->first();

        if (! $user || ! Hash::check($request->password, $user->password)) {
            throw ValidationException::withMessages([
                'username' => ['The provided credentials are incorrect.'],
            ]);
        }

        return [
            'token' => $user->createToken($user->role)->plainTextToken,
            'role' => $user->role
        ];
    }

    public function logout(Request $request)
    {
        $request->user()->tokens()->delete();
        return 1;
    }
}
