<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\SMSController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\BranchController;
use App\Http\Controllers\Api\JobOrderController;
use App\Http\Controllers\Api\OdooProductController;
use App\Http\Controllers\Api\PaymentController;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');


Route::prefix('auth')->group(function () {
    Route::post('/login', [AuthController::class, 'login'])->middleware('guest');
    Route::post('/logout', [AuthController::class, 'logout'])->middleware(['auth:sanctum']);
});

Route::middleware(['auth:sanctum'])->group(function () {
    Route::resource('users', UserController::class);
    Route::resource('branches', BranchController::class);
});

Route::get('/odoo/products', [OdooProductController::class, 'index']);

// Route::post('/odoo/pos/order', [OdooProductController::class, 'createOrder']);

Route::get('/odoo/pos/order', [OdooProductController::class, 'createOrder']);
Route::get('/artists', [UserController::class, 'index']);


Route::resource('job-orders', JobOrderController::class);

Route::post('/send-otp', [SMSController::class, 'sendOTP']);
Route::resource('payments', PaymentController::class);
