<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;


class JobOrder extends Model
{
    protected $fillable = [
        'artist_id',
        'order_no',

        'customer_name',
        'mobile_no',
        'email',

        'status',
    ];

    public function artist ()
    {
        return $this->belongsTo(User::class, 'artist_id', 'id');
    }

    public function jobOrderItems ()
    {
        return $this->hasMany(JobOrderItem::class);
    }
}
