<?php

namespace App\Http\Controllers\Api;

use App\Models\JobOrder;
use App\Models\JobOrderItem;
use App\Models\OneTimePin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;

class SMSController extends Controller
{

    public function sendOTP (Request $request)
    {

        $jobOrder = JobOrder::where('order_no', $request->order_no)->first();

        $otp = OneTimePin::create([
            'otp' => rand(100000, 999999),
            'mobile_no' => $jobOrder->mobile_no,
            'email' => $jobOrder->email,
        ]);

        // return $otp->otp;
        
        $total = 0;
        
        $msg = '';
        
        $msg .= 'Hi ' . $jobOrder->customer_name . PHP_EOL . PHP_EOL;
        $msg .= 'You requested the following services:' . PHP_EOL . PHP_EOL;
        
        foreach (JobOrderItem::where('job_order_id', $jobOrder->id)->get() as $item) {
            $total += $item->list_price;
            $msg .= $item->service_name . ' = ' . $item->list_price . PHP_EOL;
        }
        
        $msg .= 'Total ' . $total . PHP_EOL . PHP_EOL;
        
        $msg .= 'To confirm this transaction, your OTP is:' . $otp->otp;
        
        $response = Http::post('https://api.itexmo.com/api/broadcast', [
            'Email' => 'cloud.rweb@gmail.com',
            'Password' => 'RW3bS0luti0nsC0rp',
            'Recipients' => [$jobOrder->mobile_no],
            'Message' => $msg,
            'ApiCode' => 'PR-RWEBS392247_7EMET',
            'SenderId' => 'R Web Corp',
        ]);
        
        return $response;

        return [
            'response' => $response,
            'mobile_no' => $jobOrder->mobile_no
        ];
    }
}
