<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\JobOrder;
use App\Models\Payment;
use Illuminate\Http\Request;

use App\Services\OdooClient;

class PaymentController extends Controller
{
    public function index (Request $request)
    {
        return Payment::with('jobOrder')->get();
    }

    public function store (Request $request, OdooClient $odoo)
    {
        $request->validate([
            'job_order_id' => 'required|exists:job_orders,id',
            'amount' => 'required',
            'payment_type' => 'required'
        ]);

        $jo = JobOrder::find($request->job_order_id);

        
        if ($request->payment_type === 'Full Payment') {
            if ($jo->jobOrderItems->count() == 1) {
                $sessionId = $odoo->getOpenPosSessionId(3);
                
                $qty        = 1.0;
                $priceUnit  = number_format($jo->jobOrderItems[0]->list_price);
                $lineSubtot = $qty * $priceUnit;   // 1.0 (tax excl)
                $lineTotal  = $lineSubtot;   
                $attrText   = $jo->jobOrderItems[0]->attribute_text;
                
                $lines[] = 
                 [
                    0,
                    0,
                    [
                        'product_id'           => $jo->jobOrderItems[0]->product_id,
                        'qty'                  => $qty,
                        'price_unit'           => $priceUnit,
                        'customer_note'        => $attrText,
                        'tax_ids'              => [],
                        'price_subtotal'       => $lineSubtot,
                        'price_subtotal_incl'  => $lineTotal,
                    ],
                ];
                
                $payments = Payment::where('job_order_id', $jo->id)->sum('amount');
                if ($payments) {
                    
                    $lines[] = 
                     [
                        0,
                        0,
                        [
                            'product_id'           => 2,
                            'qty'                  => 1.0,
                            'price_unit'           => -1 * $payments,
                            'tax_ids'              => [],
                            'price_subtotal'       => -1 * $payments,
                            'price_subtotal_incl'  => -1 * $payments,
                        ],
                    ];
                    
                } 
               
                $subtotal   = $lineSubtot;  // 1.0
                $taxAmount  = 0.0;
                $total      = $subtotal + $taxAmount;
                $amountPaid = $total;
                $change     = 0.0;
                // 3. Build order values (pos.order)
                $orderValues = [
                    'session_id'    => $sessionId,
                    'partner_id'    => $request->integer('customer_id') ?: false,
                
                    'lines'         => $lines,
                
                    // 🔴 Header monetary fields – all numeric
                    'amount_tax'    => $taxAmount,   // 0.0
                    'amount_total'  => $total,       // 1.0
                    'amount_paid'   => $amountPaid,  // 1.0
                    'amount_return' => $change,      // 0.0
                ];
        
                try {
                    $orderId = $odoo->createPosOrder($orderValues);
                    $request->request->add([
                        'receipt_no' =>  $orderId
                    ]);
            
                    // return response()->json([
                    //     'status'           => 'ok',
                    //     'odoo_pos_order_id'=> $orderId,
                    //     'order_values'     => $orderValues,
                    // ]);
                } catch (\Throwable $e) {
                    return response()->json([
                        'status'  => 'error',
                        'message' => $e->getMessage(),
                    ], 500);
                }
                
            }
            

            
            $jo->status = 'Completed';
            $jo->save();
        }
        
        else {
            
            $sessionId = $odoo->getOpenPosSessionId(3);
            
            $qty        = 1.0;
            $priceUnit  = number_format($request->amount);
            $lineSubtot = $qty * $priceUnit;   // 1.0 (tax excl)
            $lineTotal  = $lineSubtot;   
       
            $lines[] = 
             [
                0,
                0,
                [
                    'product_id'           => 2,
                    'qty'                  => $qty,
                    'price_unit'           => $priceUnit,
                    'tax_ids'              => [],          // no tax
                    'price_subtotal'       => $lineSubtot, // 🔴 REQUIRED
                    'price_subtotal_incl'  => $lineTotal,  // good to send too
                ],
            ];
           
            $subtotal   = $lineSubtot;  // 1.0
            $taxAmount  = 0.0;
            $total      = $subtotal + $taxAmount;
            $amountPaid = $total;
            $change     = 0.0;
            // 3. Build order values (pos.order)
            $orderValues = [
                'session_id'    => $sessionId,
                'partner_id'    => $request->integer('customer_id') ?: false,
            
                'lines'         => $lines,
            
                // 🔴 Header monetary fields – all numeric
                'amount_tax'    => $taxAmount,   // 0.0
                'amount_total'  => $total,       // 1.0
                'amount_paid'   => $amountPaid,  // 1.0
                'amount_return' => $change,      // 0.0
            ];
    
            try {
                $orderId = $odoo->createPosOrder($orderValues);
                $request->request->add([
                    'receipt_no' =>  $orderId
                ]);
        
                // return response()->json([
                //     'status'           => 'ok',
                //     'odoo_pos_order_id'=> $orderId,
                //     'order_values'     => $orderValues,
                // ]);
            } catch (\Throwable $e) {
                return response()->json([
                    'status'  => 'error',
                    'message' => $e->getMessage(),
                ], 500);
            }
            
        }
        
        $payment = Payment::create($request->all());

        return $payment;
    }
    
    public function update (Request $request, $id, OdooClient $odoo)
    {
        
        $sessionId = $odoo->getOpenPosSessionId(3);
        
        $payment = Payment::find($id);
        
        $payment->update([
            'status' => 'Paid'    
        ]);
        
        
        $qty        = 1.0;
        $priceUnit  = number_format($payment->amount, 2);
        $lineSubtot = $qty * $priceUnit;   // 1.0 (tax excl)
        $lineTotal  = $lineSubtot;   
        
        $lines[] = 
         [
            0,
            0,
            [
                'product_id'           => 2,
                'qty'                  => 1,
                'price_unit'           => $priceUnit,
                'tax_ids'              => [],          // no tax
                'price_subtotal'       => $lineSubtot, // 🔴 REQUIRED
                'price_subtotal_incl'  => $lineTotal,  // good to send too
            ],
        ];
        
        $subtotal   = $lineSubtot;  // 1.0
        $taxAmount  = 0.0;
        $total      = $subtotal + $taxAmount;
        $amountPaid = $total;
        $change     = 0.0;
        // 3. Build order values (pos.order)
        $orderValues = [
            'session_id'    => $sessionId,
            'partner_id'    => $request->integer('customer_id') ?: false,
        
            'lines'         => $lines,
        
            // 🔴 Header monetary fields – all numeric
            'amount_tax'    => $taxAmount,   // 0.0
            'amount_total'  => $total,       // 1.0
            'amount_paid'   => $amountPaid,  // 1.0
            'amount_return' => $change,      // 0.0
        ];

        $orderId = $odoo->createPosOrder($orderValues);

        $payment->receipt_no = $orderId;
        $payment->save();
        return 1;
    }
    
}
